/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public final class VWConditionsTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_CONDITIONID = 0;
    public static final int COL_WORKFLOW = 1;
    public static final int COL_CONDITION = 2;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private Vector<VWEventDefinition> m_rowData = null;
    private Vector<String> m_conditionInfo = null;

    public VWConditionsTableModel(VWAuthPropertyData authPropertyData, VWInstructionDefinition instructionDef) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_instructionDef = instructionDef;
            this.m_rowData = new Vector();
            this.m_conditionInfo = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        block3: {
            try {
                if (nRowIndex > -1) {
                    this.m_rowData.removeElementAt(nRowIndex);
                    this.m_conditionInfo.removeElementAt(nRowIndex);
                    this.updateWFEInstruction();
                    this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block3;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    public void addItem() {
        try {
            VWEventDefinition eventDef = VWInstruction.WaitForEventInstructionCreateEvent(this.m_instructionDef);
            this.addEventItem(eventDef);
            int rowIndex = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(rowIndex, rowIndex);
            this.updateWFEInstruction();
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addEventItem(VWEventDefinition event) {
        try {
            this.m_rowData.addElement(event);
            String identifier = this.getIdentifier(event.getWorkClassName());
            String comparisonOperator = event.getComparisonOperator();
            String expression = event.getValue();
            StringBuffer buffer = new StringBuffer();
            if (identifier != null && VWStringUtils.compare(identifier, "") != 0) {
                buffer.append(identifier);
            }
            if (comparisonOperator != null && VWStringUtils.compare(comparisonOperator, "") != 0) {
                buffer.append(" " + comparisonOperator + " ");
            }
            if (expression != null && VWStringUtils.compare(expression, "") != 0) {
                buffer.append(expression);
            }
            this.m_conditionInfo.addElement(buffer.toString());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWInstructionDefinition instructionDef) {
        try {
            this.m_instructionDef = instructionDef;
            this.m_rowData.removeAllElements();
            this.m_conditionInfo.removeAllElements();
            if (this.m_instructionDef != null) {
                int eventDefCount;
                VWEventDefinition[] eventDefs = VWInstruction.WaitForEventInstructionGetEvents(this.m_instructionDef);
                if (eventDefs != null && (eventDefCount = eventDefs.length) > 0) {
                    for (int i = 0; i < eventDefCount; ++i) {
                        this.addEventItem(eventDefs[i]);
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        String resultString = null;
        switch (nColumnIndex) {
            case 0: {
                resultString = "#";
                break;
            }
            case 1: {
                resultString = VWResource.s_workflowStr;
                break;
            }
            case 2: {
                resultString = VWResource.s_conditionStr;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        int rowCount = 0;
        if (this.m_rowData != null) {
            rowCount = this.m_rowData.size();
        }
        return rowCount;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        String object = "";
        try {
            VWEventDefinition event = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    object = Integer.toString(nRowIndex + 1);
                    break;
                }
                case 1: {
                    object = event.getWorkClassName();
                    break;
                }
                case 2: {
                    object = this.m_conditionInfo.elementAt(nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return object;
    }

    public void updateConditionInfo(int rowIndex) {
        try {
            VWEventDefinition event = this.getItemAt(rowIndex);
            String identifier = this.getIdentifier(event.getWorkClassName());
            String comparisonOperator = event.getComparisonOperator();
            String expression = event.getValue();
            StringBuffer buffer = new StringBuffer();
            if (identifier != null && VWStringUtils.compare(identifier, "") != 0) {
                buffer.append(identifier);
            }
            if (comparisonOperator != null && VWStringUtils.compare(comparisonOperator, "") != 0) {
                buffer.append(" " + comparisonOperator + " ");
            }
            if (expression != null && VWStringUtils.compare(expression, "") != 0) {
                buffer.append(expression);
            }
            this.m_conditionInfo.setElementAt(buffer.toString(), rowIndex);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public VWEventDefinition getItemAt(int nRowIndex) {
        VWEventDefinition event = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            event = this.m_rowData.elementAt(nRowIndex);
        }
        return event;
    }

    public void up(int nRowIndex) {
        try {
            if (nRowIndex != 0) {
                VWEventDefinition currentObj = this.m_rowData.elementAt(nRowIndex);
                VWEventDefinition previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.updateConditionInfo(nRowIndex);
                this.updateConditionInfo(nRowIndex - 1);
                this.fireTableDataChanged();
                this.updateWFEInstruction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int nRowIndex) {
        try {
            if (nRowIndex < this.getRowCount() - 1) {
                VWEventDefinition currentObj = this.m_rowData.elementAt(nRowIndex);
                VWEventDefinition previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.updateConditionInfo(nRowIndex);
                this.updateConditionInfo(nRowIndex + 1);
                this.fireTableDataChanged();
                this.updateWFEInstruction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateWFEInstruction() {
        Object[] eventDefs = new VWEventDefinition[this.m_rowData.size()];
        this.m_rowData.copyInto(eventDefs);
        VWInstruction.WaitForEventInstructionSetEvents(this.m_instructionDef, (VWEventDefinition[])eventDefs);
        this.m_authPropertyData.setDirty();
    }

    private String getIdentifier(String workflowName) {
        String identifier = "";
        try {
            VWWorkflowSignature workflowSignature;
            VWSession session;
            if (this.m_authPropertyData != null && workflowName != null && VWStringUtils.compare(workflowName, "") != 0 && (session = this.m_authPropertyData.getVWSession()) != null && (workflowSignature = VWClassFactory.VWWorkflowDefinition_fetchWorkflowSignature(workflowName, session, this.m_authPropertyData.getWorkflowDefinition(), 234L)) != null) {
                identifier = workflowSignature.getFTagExpression();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return identifier;
    }
}

